"""
HB_DefaultCamera V1.2

Last Modified: 6/31/2016
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_DefaultCamera

Description-US: Enables Default Viewport Camera and makes some other things (Details in Script)
This Script does following:
1.Changes the Viewport Camera to the Default Editor Camera 
2.Sets Model Mode.
3.Activate Move Tool
4.Delete the HB_ModellingCamera if it exists and resets the Workplane.
5.Align Workplane to Y if HB_ModellingCamera is active

VideoTutorial:
https://youtu.be/eEcAttV56kE?t=2m9s


ChangeLog:


Jun/11/2015 V1.0:
- Release Version

Jun/31/2016 V1.1:
- Support for HB_ZoomCamera

Oct/11/2018 V1.2:
- new Highres Icon


"""
import c4d

def main():
    doc.StartUndo()
    c4d.CallCommand(12298) # Model
    c4d.CallCommand(200000088) # Move
    c4dVersion= c4d.GetC4DVersion()
    bd= doc.GetActiveBaseDraw()
    EditorCam = bd.GetEditorCamera()
    
    doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=EditorCam
    
    
    Workplanecamera = doc.SearchObject("HB_ModellingCamera_ROOT")
    ZoomCamera = doc.SearchObject("HB_ZoomCamera")

    
    if ZoomCamera:
        RootCam = ZoomCamera.GetUp()
        doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=RootCam
        doc.AddUndo(c4d.UNDOTYPE_NEW, ZoomCamera)
        ZoomCamera.Remove()
    
    if Workplanecamera:
        if c4dVersion >= 16000:
            
            bd[c4d.BASEDRAW_DISPLAYFILTER_BASEGRID]=True
        doc.AddUndo(c4d.UNDOTYPE_NEW, Workplanecamera)
        Workplanecamera.Remove()
        c4d.CallCommand(431000007) # Align Workplane to Y
    
    doc.EndUndo()
    c4d.EventAdd()
    
if __name__=='__main__':
    main()
